import { UTF_16 } from '../../utils/UTF_16.js';
import type { UTF_8 } from '../../utils/UTF_8.js';
/**
 * Gets the PlayReady license request headers from the MediaKeyMessageEvent.
 *
 * @param message - An ArrayBuffer from the content decryption module.
 * @param encoding - The message encoding type. Default is UTF-16.
 * @returns Request headers.
 *
 * @group DRM
 * @beta
 *
 * @example
 * {@includeCode ../../../test/drm/playready/getRequestHeadersFromMessage.test.ts#example}
 */
export declare function getRequestHeadersFromMessage(message: ArrayBuffer, encoding?: typeof UTF_8 | typeof UTF_16): Record<string, string>;
//# sourceMappingURL=getRequestHeadersFromMessage.d.ts.map