import type { Encoding } from '../../utils/Encoding.js';
/**
 * Gets the PlayReady license request from the MediaKeyMessageEvent.
 *
 * @param message - An ArrayBuffer from the content decryption module.
 * @param encoding - The message encoding type. Default is UTF-16.
 * @returns The license request as an ArrayBuffer.
 *
 * @group DRM
 * @beta
 *
 * @example
 * {@includeCode ../../../test/drm/playready/getLicenseRequestFromMessage.test.ts#example}
 */
export declare function getLicenseRequestFromMessage(message: ArrayBuffer, encoding?: Encoding): ArrayBuffer;
//# sourceMappingURL=getLicenseRequestFromMessage.d.ts.map