"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLegacyKeySystemAccess = getLegacyKeySystemAccess;
const createMediaKeySystemConfiguration_js_1 = require("./createMediaKeySystemConfiguration.js");
const getSupportedKeySystemConfiguration_js_1 = require("./getSupportedKeySystemConfiguration.js");
/**
 * Fallback method to get key system access using legacy MediaKeys.isTypeSupported().
 *
 * @param ksConfigurations - An array of key system configurations.
 * @returns A KeySystemAccess object if successful, or null if no system is supported.
 *
 * @group DRM
 * @beta
 */
function getLegacyKeySystemAccess(ksConfigurations) {
    for (const { ks, configs } of ksConfigurations) {
        const supportedConfig = (0, getSupportedKeySystemConfiguration_js_1.getSupportedKeySystemConfiguration)(ks.systemString, configs);
        if (supportedConfig) {
            const configuration = (0, createMediaKeySystemConfiguration_js_1.createMediaKeySystemConfiguration)(supportedConfig.supportedAudio, supportedConfig.supportedVideo);
            return {
                keySystem: ks.systemString,
                configuration,
            };
        }
    }
    return null;
}
//# sourceMappingURL=getLegacyKeySystemAccess.js.map