import type { KeySystemConfiguration } from '../common/KeySystemConfiguration.js';
import type { MediaCapability } from '../common/MediaCapability.js';
/**
 * Creates a valid KeySystemConfiguration from supported audio and video capabilities.
 *
 * @param supportedAudio - supported audio capabilities.
 * @param supportedVideo - supported video capabilities.
 * @returns KeySystemConfiguration object.
 *
 * @group DRM
 * @beta
 *
 * @example
 * {@includeCode ../../../test/drm/keysystem/createMediaKeySystemConfiguration.test.ts#example}
 */
export declare function createMediaKeySystemConfiguration(supportedAudio: MediaCapability[] | null, supportedVideo: MediaCapability[] | null): KeySystemConfiguration;
//# sourceMappingURL=createMediaKeySystemConfiguration.d.ts.map