"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decodeFairPlayLicense = decodeFairPlayLicense;
const base64decode_js_1 = require("../../utils/base64decode.js");
/**
 * Decodes a FairPlay DRM license response.
 *
 * @param response - The license response, either a base64 string or ArrayBuffer
 * @returns A Uint8Array containing the decoded license
 *
 * @group DRM
 * @beta
 *
 * @example
 * {@includeCode ../../../test/drm/fairplay/decodeFairPlayLicense.test.ts#example}
 */
function decodeFairPlayLicense(response) {
    return typeof response === 'string'
        ? (0, base64decode_js_1.base64decode)(response)
        : new Uint8Array(response);
}
//# sourceMappingURL=decodeFairPlayLicense.js.map