/**
 * Concatenates InitData, ID, and Certificate for FairPlay DRM.
 *
 * @param initData - The initialization data (PSSH box)
 * @param id - The content ID (string or Uint16Array)
 * @param cert - The application certificate (Uint8Array)
 * @returns A Uint8Array containing the concatenated data
 *
 * @group DRM
 * @beta
 *
 * @example
 * {@includeCode ../../../test/drm/fairplay/concatInitDataIdAndCertificate.test.ts#example}
 */
export declare function concatInitDataIdAndCertificate(initData: Uint16Array, id: Uint16Array | string, cert: Uint8Array): Uint8Array;
//# sourceMappingURL=concatInitDataIdAndCertificate.d.ts.map