"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseInitDataFromContentProtection = parseInitDataFromContentProtection;
/**
 * Parse a standard common encryption PSSH which contains a simple
 * base64-encoding of the init data
 *
 * @param cpData - The ContentProtection element that may contain PSSH data.
 * @param BASE64 - The BASE64 reference.
 * @returns init data as an ArrayBuffer, or null if not found.
 *
 * @group DRM
 * @beta
 *
 * @example
 * {@includeCode ../../../test/drm/cenc/parseInitDataFromContentProtection.test.ts#example}
 */
function parseInitDataFromContentProtection(cpData, BASE64) {
    if ((cpData === null || cpData === void 0 ? void 0 : cpData.pssh) && cpData.pssh) {
        const cleanedText = cpData.pssh.replace(/\r?\n|\r/g, '').replace(/\s+/g, '');
        return BASE64.decodeArray(cleanedText).buffer;
    }
    return null;
}
//# sourceMappingURL=parseInitDataFromContentProtection.js.map