"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLicenseServerUrlFromContentProtection = getLicenseServerUrlFromContentProtection;
/**
 * Extracts a license server URL from an array of ContentProtection elements.
 *
 * @param contentProtectionElements - Array of ContentProtection nodes from the manifest.
 * @param schemeIdUri - schemeIdUri we are searching for.
 * @returns The license server URL, and if not found then null.
 *
 * @group DRM
 * @beta
 *
 * @example
 * {@includeCode ../../../test/drm/cenc/getLicenseServerUrlFromContentProtection.test.ts#example}
 */
function getLicenseServerUrlFromContentProtection(contentProtectionElements, schemeIdUri) {
    if (!Array.isArray(contentProtectionElements)) {
        return null;
    }
    for (const cp of contentProtectionElements) {
        if (cp.schemeIdUri === schemeIdUri) {
            const laUrl = cp.laUrl;
            if (laUrl && typeof laUrl === 'string') {
                return laUrl;
            }
            if (typeof laUrl === 'object' && laUrl && typeof laUrl === 'string') {
                return laUrl;
            }
        }
    }
    return null;
}
//# sourceMappingURL=getLicenseServerUrlFromContentProtection.js.map