"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findCencContentProtection = findCencContentProtection;
const CBCS_js_1 = require("../common/CBCS.js");
const CENC_js_1 = require("../common/CENC.js");
const MP4_PROTECTION_SCHEME_js_1 = require("../common/MP4_PROTECTION_SCHEME.js");
/**
 * Finds and returns the ContentProtection element for MP4 Common Encryption.
 *
 * @param cpArray - Array of ContentProtection elements.
 * @returns The Common Encryption content protection element, or null if not found.
 *
 * @group DRM
 * @beta
 *
 * @example
 * {@includeCode ../../../test/drm/cenc/findCencContentProtection.test.ts#example}
 */
function findCencContentProtection(cpArray) {
    var _a;
    if (!cpArray) {
        return null;
    }
    for (const cp of cpArray) {
        if (((_a = cp.schemeIdUri) === null || _a === void 0 ? void 0 : _a.toLowerCase()) === MP4_PROTECTION_SCHEME_js_1.MP4_PROTECTION_SCHEME &&
            cp.value &&
            (cp.value.toLowerCase() === CENC_js_1.CENC ||
                cp.value.toLowerCase() === CBCS_js_1.CBCS)) {
            return cp;
        }
    }
    return null;
}
//# sourceMappingURL=findCencContentProtection.js.map