"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.videoPlaylistsToSwitchingSets = videoPlaylistsToSwitchingSets;
const constants_js_1 = require("../../../utils/constants.js");
const parseHlsManifest_js_1 = require("../../../utils/hls/parseHlsManifest.js");
const formatSegments_js_1 = require("./utils/formatSegments.js");
const getByterange_js_1 = require("./utils/getByterange.js");
const getCodec_js_1 = require("./utils/getCodec.js");
const getDuration_js_1 = require("./utils/getDuration.js");
function videoPlaylistsToSwitchingSets(playlists, manifestPlaylists) {
    const switchingSetVideos = [];
    const videoTracks = [];
    let videoTrackId = 0;
    playlists.map((playlist) => {
        var _a, _b, _c, _d;
        const parsedHlsManifest = (0, parseHlsManifest_js_1.parseHlsManifest)((_a = manifestPlaylists.shift()) === null || _a === void 0 ? void 0 : _a.manifest);
        const segments = (0, formatSegments_js_1.formatSegments)(parsedHlsManifest === null || parsedHlsManifest === void 0 ? void 0 : parsedHlsManifest.segments);
        const { LANGUAGE, CODECS, BANDWIDTH } = playlist.attributes;
        const map = (_c = (_b = parsedHlsManifest === null || parsedHlsManifest === void 0 ? void 0 : parsedHlsManifest.segments) === null || _b === void 0 ? void 0 : _b.at(0)) === null || _c === void 0 ? void 0 : _c.map;
        const byteRange = (0, getByterange_js_1.getByterange)(map === null || map === void 0 ? void 0 : map.byterange);
        videoTracks.push({
            id: `video-${videoTrackId++}`,
            type: 'video',
            fileName: playlist.uri,
            codec: (0, getCodec_js_1.getCodec)('video', CODECS),
            duration: (0, getDuration_js_1.getDuration)(parsedHlsManifest, segments),
            language: LANGUAGE !== null && LANGUAGE !== void 0 ? LANGUAGE : 'und',
            bandwidth: BANDWIDTH,
            segments: segments,
            width: playlist.attributes.RESOLUTION.width,
            height: playlist.attributes.RESOLUTION.height,
            frameRate: {
                frameRateNumerator: (_d = playlist.attributes['FRAME-RATE']) !== null && _d !== void 0 ? _d : constants_js_1.FRAME_RATE_NUMERATOR_30,
                frameRateDenominator: constants_js_1.ZERO,
            },
            par: '',
            sar: '',
            scanType: '',
            ...(byteRange && { byteRange }),
            ...((map === null || map === void 0 ? void 0 : map.uri) && { urlInitialization: map === null || map === void 0 ? void 0 : map.uri }),
        });
    });
    switchingSetVideos.push({
        id: `video`,
        tracks: videoTracks,
    });
    return switchingSetVideos;
}
//# sourceMappingURL=videoPlaylistsToSwitchingSets.js.map