"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.subtitleGroupsToSwitchingSets = subtitleGroupsToSwitchingSets;
const parseHlsManifest_js_1 = require("../../../utils/hls/parseHlsManifest.js");
const formatSegments_js_1 = require("./utils/formatSegments.js");
const getCodec_js_1 = require("./utils/getCodec.js");
const getDuration_js_1 = require("./utils/getDuration.js");
function subtitleGroupsToSwitchingSets(mediaGroupsSubtitles, manifestPlaylists) {
    var _a;
    const subtitleSwitchingSets = [];
    const textTracks = [];
    // Add selection set of type subtitles
    for (const subtitleEncodings in mediaGroupsSubtitles) {
        const encodings = mediaGroupsSubtitles[subtitleEncodings];
        for (const subtitle in encodings) {
            const attributes = encodings[subtitle];
            const { language, uri } = attributes;
            const subtitleParsed = (0, parseHlsManifest_js_1.parseHlsManifest)((_a = manifestPlaylists.shift()) === null || _a === void 0 ? void 0 : _a.manifest);
            const segments = (0, formatSegments_js_1.formatSegments)(subtitleParsed === null || subtitleParsed === void 0 ? void 0 : subtitleParsed.segments);
            textTracks.push({
                id: subtitle,
                type: 'text',
                fileName: uri,
                codec: (0, getCodec_js_1.getCodec)('text'),
                duration: (0, getDuration_js_1.getDuration)(subtitleParsed, segments),
                language: language,
                bandwidth: 0,
                segments: segments,
            });
        }
    }
    subtitleSwitchingSets.push({
        id: 'text',
        tracks: textTracks,
    });
    return subtitleSwitchingSets;
}
//# sourceMappingURL=subtitleGroupsToSwitchingSets.js.map