"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.audioGroupsToSwitchingSets = audioGroupsToSwitchingSets;
const parseHlsManifest_js_1 = require("../../../utils/hls/parseHlsManifest.js");
const formatSegments_js_1 = require("./utils/formatSegments.js");
const getByterange_js_1 = require("./utils/getByterange.js");
const getCodec_js_1 = require("./utils/getCodec.js");
const getDuration_js_1 = require("./utils/getDuration.js");
/**
 * @internal
 *
 * This function is used to convert audio groups to switching sets.
 *
 *
 * @param mediaGroupsAudio - Any
 * @param manifestPlaylists - Array of Manifest
 * @returns Array of switchingSet
 *
 * @group CMAF
 * @alpha
 */
function audioGroupsToSwitchingSets(mediaGroupsAudio, manifestPlaylists) {
    var _a, _b;
    const audioSwitchingSets = [];
    const audioTracks = [];
    for (const audioEncodings in mediaGroupsAudio) {
        const encodings = mediaGroupsAudio[audioEncodings];
        for (const audio in encodings) {
            const attributes = encodings[audio];
            const { language, uri } = attributes;
            const audioParsed = (0, parseHlsManifest_js_1.parseHlsManifest)((_a = manifestPlaylists.shift()) === null || _a === void 0 ? void 0 : _a.manifest);
            const map = (_b = audioParsed === null || audioParsed === void 0 ? void 0 : audioParsed.segments[0]) === null || _b === void 0 ? void 0 : _b.map;
            const segments = (0, formatSegments_js_1.formatSegments)(audioParsed === null || audioParsed === void 0 ? void 0 : audioParsed.segments);
            // TODO: channels, sampleRate, bandwith and codec need to be
            // updated with real values. Right now we are using simple hardcoded values.
            const byteRange = (0, getByterange_js_1.getByterange)(map === null || map === void 0 ? void 0 : map.byterange);
            audioTracks.push({
                id: audio,
                type: 'audio',
                fileName: uri,
                codec: (0, getCodec_js_1.getCodec)('audio'),
                duration: (0, getDuration_js_1.getDuration)(audioParsed, segments),
                language: language,
                bandwidth: 0,
                segments: segments,
                sampleRate: 0,
                channels: 2,
                ...(byteRange && { byteRange }),
                ...((map === null || map === void 0 ? void 0 : map.uri) && { urlInitialization: map === null || map === void 0 ? void 0 : map.uri }),
            });
        }
    }
    audioSwitchingSets.push({
        id: 'audio',
        tracks: audioTracks,
    });
    return audioSwitchingSets;
}
//# sourceMappingURL=audioGroupsToSwitchingSets.js.map