import type { Representation } from '../../../../types/mapper/dash/Representation.js';
import type { SegmentTemplate } from '../../../../types/mapper/dash/SegmentTemplate.js';
/**
 * @internal
 *
 * Create the url from a segment template.
 *
 * Searches for substrings with the format `$value$` and replaces it with the correct value.
 * - RepresentationID: id of the representation
 * - Number: id of the segment. `%0Xd` defines the number `X` of digits it needs to have
 *
 * @param representation - Representation of the template
 * @param segmentTemplate - Segment template
 * @param segmentId - Segment id
 * @returns url from the segment template
 */
export declare function getUrlFromTemplate(representation: Representation, segmentTemplate: SegmentTemplate, segmentId: number): string;
//# sourceMappingURL=getUrlFromTemplate.d.ts.map