"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.manageFetchMockGlobally = manageFetchMockGlobally;
const vitest_1 = require("vitest");
const fetch_mock_1 = require("fetch-mock");
require("./vitest-extensions.js");
class FetchMockVitest extends fetch_mock_1.FetchMock {
    mockClear() {
        this.clearHistory();
        return this;
    }
    mockReset(options = { includeSticky: false }) {
        this.removeRoutes({
            ...options,
            includeFallback: true,
        });
        return this.mockClear();
    }
    mockRestore(options) {
        this.unmockGlobal();
        return this.mockReset(options);
    }
}
function manageFetchMockGlobally() {
    const { clearAllMocks, resetAllMocks, restoreAllMocks, unstubAllGlobals } = vitest_1.vi;
    vitest_1.vi.clearAllMocks = () => {
        clearAllMocks.apply(vitest_1.vi);
        fetchMockVitest.mockClear();
        return vitest_1.vi;
    };
    vitest_1.vi.resetAllMocks = () => {
        resetAllMocks.apply(vitest_1.vi);
        fetchMockVitest.mockReset();
        return vitest_1.vi;
    };
    vitest_1.vi.restoreAllMocks = () => {
        restoreAllMocks.apply(vitest_1.vi);
        fetchMockVitest.mockRestore();
        return vitest_1.vi;
    };
    vitest_1.vi.unstubAllGlobals = () => {
        unstubAllGlobals.apply(vitest_1.vi);
        fetchMockVitest.mockRestore();
        return vitest_1.vi;
    };
}
const fetchMockVitest = new FetchMockVitest({
    ...fetch_mock_1.defaultFetchMockConfig,
});
exports.default = fetchMockVitest;
