import type { Comment } from "./Comment";
import type { CommentActions } from "./CommentActions";
import type { CommentReport } from "./CommentReport";
import type { Community } from "./Community";
import type { CommunityActions } from "./CommunityActions";
import type { Person } from "./Person";
import type { PersonActions } from "./PersonActions";
import type { Post } from "./Post";
/**
 * A comment report view.
 */
export type CommentReportView = {
    comment_report: CommentReport;
    comment: Comment;
    post: Post;
    community: Community;
    creator: Person;
    comment_creator: Person;
    comment_actions?: CommentActions;
    resolver?: Person;
    person_actions?: PersonActions;
    community_actions?: CommunityActions;
    creator_is_admin: boolean;
};
