"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const asyncBatcher = require("./async-batcher.cjs");
const asyncDebouncer = require("./async-debouncer.cjs");
const asyncQueuer = require("./async-queuer.cjs");
const asyncRateLimiter = require("./async-rate-limiter.cjs");
const asyncThrottler = require("./async-throttler.cjs");
const batcher = require("./batcher.cjs");
const debouncer = require("./debouncer.cjs");
const queuer = require("./queuer.cjs");
const rateLimiter = require("./rate-limiter.cjs");
const throttler = require("./throttler.cjs");
const utils = require("./utils.cjs");
exports.AsyncBatcher = asyncBatcher.AsyncBatcher;
exports.asyncBatch = asyncBatcher.asyncBatch;
exports.AsyncDebouncer = asyncDebouncer.AsyncDebouncer;
exports.asyncDebounce = asyncDebouncer.asyncDebounce;
exports.AsyncQueuer = asyncQueuer.AsyncQueuer;
exports.asyncQueue = asyncQueuer.asyncQueue;
exports.AsyncRateLimiter = asyncRateLimiter.AsyncRateLimiter;
exports.asyncRateLimit = asyncRateLimiter.asyncRateLimit;
exports.AsyncThrottler = asyncThrottler.AsyncThrottler;
exports.asyncThrottle = asyncThrottler.asyncThrottle;
exports.Batcher = batcher.Batcher;
exports.batch = batcher.batch;
exports.Debouncer = debouncer.Debouncer;
exports.debounce = debouncer.debounce;
exports.Queuer = queuer.Queuer;
exports.queue = queuer.queue;
exports.RateLimiter = rateLimiter.RateLimiter;
exports.rateLimit = rateLimiter.rateLimit;
exports.Throttler = throttler.Throttler;
exports.throttle = throttler.throttle;
exports.isFunction = utils.isFunction;
exports.parseFunctionOrValue = utils.parseFunctionOrValue;
//# sourceMappingURL=index.cjs.map
