import { TabName } from '../tabs.cjs';
import { TanStackDevtoolsPlugin } from './devtools-context.cjs';
type ModifierKey = 'Alt' | 'Control' | 'Meta' | 'Shift';
type KeyboardKey = ModifierKey | (string & {});
type TriggerPosition = 'top-left' | 'top-right' | 'bottom-left' | 'bottom-right' | 'middle-left' | 'middle-right';
export type DevtoolsStore = {
    settings: {
        /**
         * Whether the dev tools should be open by default
         * @default false
         */
        defaultOpen: boolean;
        /**
         * Whether the dev tools trigger should be hidden until the user hovers over it
         * @default false
         */
        hideUntilHover: boolean;
        /**
         * The position of the trigger button
         * @default "bottom-right"
         */
        position: TriggerPosition;
        /**
         * The location of the panel once it is open
         * @default "bottom"
         */
        panelLocation: 'top' | 'bottom';
        /**
         * The hotkey to open the dev tools
         * @default "shift+a"
         */
        openHotkey: Array<KeyboardKey>;
        /**
         * Whether to require the URL flag to open the dev tools
         * @default false
         */
        requireUrlFlag: boolean;
        /**
         * The URL flag to open the dev tools, used in conjunction with requireUrlFlag (if set to true)
         * @default "tanstack-devtools"
         */
        urlFlag: string;
    };
    state: {
        activeTab: TabName;
        height: number;
        activePlugin?: string | undefined;
        persistOpen: boolean;
    };
    plugins?: Array<TanStackDevtoolsPlugin>;
};
export declare const initialState: DevtoolsStore;
export {};
