import { createComponent, template, insert, effect, className } from "solid-js/web";
import { For } from "solid-js";
import { useStyles } from "../styles/use-styles.js";
var _tmpl$ = /* @__PURE__ */ template(`<span>`), _tmpl$2 = /* @__PURE__ */ template(`<span><span>&quot;<!>&quot;`), _tmpl$3 = /* @__PURE__ */ template(`<span>&quot;<!>&quot;: `), _tmpl$4 = /* @__PURE__ */ template(`<span><span>`), _tmpl$5 = /* @__PURE__ */ template(`<span><span>null`), _tmpl$6 = /* @__PURE__ */ template(`<span><span>undefined`), _tmpl$7 = /* @__PURE__ */ template(`<span><span>[</span><span>]`), _tmpl$8 = /* @__PURE__ */ template(`<span><span>{</span><span>}`), _tmpl$9 = /* @__PURE__ */ template(`<span>,`);
function JsonTree(props) {
  return createComponent(JsonValue, {
    isRoot: true,
    get value() {
      return props.value;
    }
  });
}
function JsonValue(props) {
  const {
    value,
    keyName,
    isRoot = false,
    isLastKey
  } = props;
  const styles = useStyles();
  return (() => {
    var _el$ = _tmpl$();
    insert(_el$, () => {
      if (typeof value === "string") {
        return (() => {
          var _el$2 = _tmpl$2(), _el$3 = _el$2.firstChild, _el$4 = _el$3.firstChild, _el$6 = _el$4.nextSibling;
          _el$6.nextSibling;
          insert(_el$2, keyName && (() => {
            var _el$7 = _tmpl$3(), _el$8 = _el$7.firstChild, _el$10 = _el$8.nextSibling;
            _el$10.nextSibling;
            insert(_el$7, keyName, _el$10);
            effect(() => className(_el$7, styles().tree.valueKey));
            return _el$7;
          })(), _el$3);
          insert(_el$3, value, _el$6);
          effect(() => className(_el$3, styles().tree.valueString));
          return _el$2;
        })();
      }
      if (typeof value === "number") {
        return (() => {
          var _el$11 = _tmpl$4(), _el$12 = _el$11.firstChild;
          insert(_el$11, keyName && (() => {
            var _el$13 = _tmpl$3(), _el$14 = _el$13.firstChild, _el$16 = _el$14.nextSibling;
            _el$16.nextSibling;
            insert(_el$13, keyName, _el$16);
            effect(() => className(_el$13, styles().tree.valueKey));
            return _el$13;
          })(), _el$12);
          insert(_el$12, value);
          effect(() => className(_el$12, styles().tree.valueNumber));
          return _el$11;
        })();
      }
      if (typeof value === "boolean") {
        return (() => {
          var _el$17 = _tmpl$4(), _el$18 = _el$17.firstChild;
          insert(_el$17, keyName && (() => {
            var _el$19 = _tmpl$3(), _el$20 = _el$19.firstChild, _el$22 = _el$20.nextSibling;
            _el$22.nextSibling;
            insert(_el$19, keyName, _el$22);
            effect(() => className(_el$19, styles().tree.valueKey));
            return _el$19;
          })(), _el$18);
          insert(_el$18, () => String(value));
          effect(() => className(_el$18, styles().tree.valueBoolean));
          return _el$17;
        })();
      }
      if (value === null) {
        return (() => {
          var _el$23 = _tmpl$5(), _el$24 = _el$23.firstChild;
          insert(_el$23, keyName && (() => {
            var _el$25 = _tmpl$3(), _el$26 = _el$25.firstChild, _el$28 = _el$26.nextSibling;
            _el$28.nextSibling;
            insert(_el$25, keyName, _el$28);
            effect(() => className(_el$25, styles().tree.valueKey));
            return _el$25;
          })(), _el$24);
          effect(() => className(_el$24, styles().tree.valueNull));
          return _el$23;
        })();
      }
      if (value === void 0) {
        return (() => {
          var _el$29 = _tmpl$6(), _el$30 = _el$29.firstChild;
          insert(_el$29, keyName && (() => {
            var _el$31 = _tmpl$3(), _el$32 = _el$31.firstChild, _el$34 = _el$32.nextSibling;
            _el$34.nextSibling;
            insert(_el$31, keyName, _el$34);
            effect(() => className(_el$31, styles().tree.valueKey));
            return _el$31;
          })(), _el$30);
          effect(() => className(_el$30, styles().tree.valueNull));
          return _el$29;
        })();
      }
      if (Array.isArray(value)) {
        return (() => {
          var _el$35 = _tmpl$7(), _el$36 = _el$35.firstChild, _el$37 = _el$36.nextSibling;
          insert(_el$35, keyName && (() => {
            var _el$38 = _tmpl$3(), _el$39 = _el$38.firstChild, _el$41 = _el$39.nextSibling;
            _el$41.nextSibling;
            insert(_el$38, keyName, _el$41);
            effect(() => className(_el$38, styles().tree.valueKey));
            return _el$38;
          })(), _el$36);
          insert(_el$35, createComponent(For, {
            each: value,
            children: (item, i) => {
              const isLastKey2 = i() === value.length - 1;
              return createComponent(JsonValue, {
                value: item,
                isLastKey: isLastKey2
              });
            }
          }), _el$37);
          effect((_p$) => {
            var _v$ = styles().tree.valueBraces, _v$2 = styles().tree.valueBraces;
            _v$ !== _p$.e && className(_el$36, _p$.e = _v$);
            _v$2 !== _p$.t && className(_el$37, _p$.t = _v$2);
            return _p$;
          }, {
            e: void 0,
            t: void 0
          });
          return _el$35;
        })();
      }
      if (typeof value === "object") {
        const keys = Object.keys(value);
        const lastKeyName = keys[keys.length - 1];
        return (() => {
          var _el$42 = _tmpl$8(), _el$43 = _el$42.firstChild, _el$44 = _el$43.nextSibling;
          insert(_el$42, keyName && (() => {
            var _el$45 = _tmpl$3(), _el$46 = _el$45.firstChild, _el$48 = _el$46.nextSibling;
            _el$48.nextSibling;
            insert(_el$45, keyName, _el$48);
            effect(() => className(_el$45, styles().tree.valueKey));
            return _el$45;
          })(), _el$43);
          insert(_el$42, createComponent(For, {
            each: keys,
            children: (k) => createComponent(JsonValue, {
              get value() {
                return value[k];
              },
              keyName: k,
              isLastKey: lastKeyName === k
            })
          }), _el$44);
          effect((_p$) => {
            var _v$3 = styles().tree.valueBraces, _v$4 = styles().tree.valueBraces;
            _v$3 !== _p$.e && className(_el$43, _p$.e = _v$3);
            _v$4 !== _p$.t && className(_el$44, _p$.t = _v$4);
            return _p$;
          }, {
            e: void 0,
            t: void 0
          });
          return _el$42;
        })();
      }
      return _tmpl$();
    }, null);
    insert(_el$, isLastKey || isRoot ? "" : _tmpl$9(), null);
    effect(() => className(_el$, styles().tree.valueContainer(isRoot)));
    return _el$;
  })();
}
export {
  JsonTree
};
//# sourceMappingURL=tree.js.map
