import { UINT } from '../fields/UINT.js';
/**
 * Parse a VideoMediaHeaderBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed VideoMediaHeaderBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function vmhd(view) {
    return {
        ...view.readFullBox(),
        graphicsmode: view.readUint(2),
        opcolor: view.readArray(UINT, 2, 3),
    };
}
;
//# sourceMappingURL=vmhd.js.map