import { UINT } from '../fields/UINT.js';
/**
 * Parse a ProtectionSystemSpecificHeaderBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed ProtectionSystemSpecificHeaderBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function pssh(view) {
    const { readUint, readArray } = view;
    const { version, flags } = view.readFullBox();
    const systemID = readArray(UINT, 1, 16);
    const dataSize = readUint(4);
    const data = readArray(UINT, 1, dataSize);
    return {
        version,
        flags,
        systemID,
        dataSize,
        data,
    };
}
;
//# sourceMappingURL=pssh.js.map