/**
 * Parse a ProducerReferenceTimeBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed ProducerReferenceTimeBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function prft(view) {
    const { version, flags } = view.readFullBox();
    return {
        version,
        flags,
        referenceTrackId: view.readUint(4),
        ntpTimestampSec: view.readUint(4),
        ntpTimestampFrac: view.readUint(4),
        mediaTime: view.readUint(version === 1 ? 8 : 4),
    };
}
;
//# sourceMappingURL=prft.js.map