import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * A Composition Time To Sample Entry
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type CompositionTimeToSampleEntry = {
    sampleCount: number;
    sampleOffset: number;
};
/**
 * ISO/IEC 14496-12:2012 - 8.6.1.3 Composition Time To Sample Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type CompositionTimeToSampleBox = FullBox & {
    entryCount: number;
    entries: CompositionTimeToSampleEntry[];
};
/**
 * Parse a CompositionTimeToSampleBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed CompositionTimeToSampleBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function ctts(view: IsoView): CompositionTimeToSampleBox;
//# sourceMappingURL=ctts.d.ts.map