/**
 * Parse a AudioRenderingIndicationBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed AudioRenderingIndicationBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function ardi(view) {
    return {
        ...view.readFullBox(),
        audioRenderingIndication: view.readUint(1),
    };
}
;
//# sourceMappingURL=ardi.js.map