import { IsoView } from './IsoView.js';
/**
 * Create an IsoView from a raw ISO data.
 *
 * @param raw - The raw ISO data
 * @param config - The configuration for the IsoView
 *
 * @returns The created IsoView
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function createIsoView(raw, config) {
    return raw instanceof IsoView ? raw : new IsoView(raw, config);
}
//# sourceMappingURL=createIsoView.js.map