import { decodeId3ImageFrame } from './decodeId3ImageFrame.js';
import { decodeId3PrivFrame } from './decodeId3PrivFrame.js';
import { decodeId3TextFrame } from './decodeId3TextFrame.js';
import { decodeId3UrlFrame } from './decodeId3UrlFrame.js';
/**
 * Decode an ID3 frame.
 *
 * @param frame - the ID3 frame
 *
 * @returns The decoded ID3 frame
 *
 * @internal
 *
 * @group ID3
 */
export function decodeId3Frame(frame) {
    if (frame.type === 'PRIV') {
        return decodeId3PrivFrame(frame);
    }
    else if (frame.type[0] === 'W') {
        return decodeId3UrlFrame(frame);
    }
    else if (frame.type === 'APIC') {
        return decodeId3ImageFrame(frame);
    }
    return decodeId3TextFrame(frame);
}
//# sourceMappingURL=decodeId3Frame.js.map