/**
 * Parses a list of PSSH boxes into keysystem-specific PSSH data.
 *
 * @param data - The concatenated list of PSSH boxes as provided by
 * the CDM as initialization data when CommonEncryption content is detected
 * @returns An object that has a property named according to each of
 * the detected key system UUIDs (e.g. 00000000-0000-0000-0000-0000000000)
 * and a ArrayBuffer (the entire PSSH box) as the property value
 *
 * @group DRM
 * @beta
 *
 * @example
 * {@includeCode ../../../test/drm/cenc/parsePSSHList.test.ts#example}
 */
export declare function parsePSSHList(data: ArrayBuffer | null | undefined): Record<string, ArrayBuffer>;
//# sourceMappingURL=parsePSSHList.d.ts.map