import { parseHlsManifest } from '../../../utils/hls/parseHlsManifest.js';
import { formatSegments } from './utils/formatSegments.js';
import { getByterange } from './utils/getByterange.js';
import { getCodec } from './utils/getCodec.js';
import { getDuration } from './utils/getDuration.js';
/**
 * @internal
 *
 * This function is used to convert audio groups to switching sets.
 *
 *
 * @param mediaGroupsAudio - Any
 * @param manifestPlaylists - Array of Manifest
 * @returns Array of switchingSet
 *
 * @group CMAF
 * @alpha
 */
export function audioGroupsToSwitchingSets(mediaGroupsAudio, manifestPlaylists) {
    var _a, _b;
    const audioSwitchingSets = [];
    const audioTracks = [];
    for (const audioEncodings in mediaGroupsAudio) {
        const encodings = mediaGroupsAudio[audioEncodings];
        for (const audio in encodings) {
            const attributes = encodings[audio];
            const { language, uri } = attributes;
            const audioParsed = parseHlsManifest((_a = manifestPlaylists.shift()) === null || _a === void 0 ? void 0 : _a.manifest);
            const map = (_b = audioParsed === null || audioParsed === void 0 ? void 0 : audioParsed.segments[0]) === null || _b === void 0 ? void 0 : _b.map;
            const segments = formatSegments(audioParsed === null || audioParsed === void 0 ? void 0 : audioParsed.segments);
            // TODO: channels, sampleRate, bandwith and codec need to be
            // updated with real values. Right now we are using simple hardcoded values.
            const byteRange = getByterange(map === null || map === void 0 ? void 0 : map.byterange);
            audioTracks.push({
                id: audio,
                type: 'audio',
                fileName: uri,
                codec: getCodec('audio'),
                duration: getDuration(audioParsed, segments),
                language: language,
                bandwidth: 0,
                segments: segments,
                sampleRate: 0,
                channels: 2,
                ...(byteRange && { byteRange }),
                ...((map === null || map === void 0 ? void 0 : map.uri) && { urlInitialization: map === null || map === void 0 ? void 0 : map.uri }),
            });
        }
    }
    audioSwitchingSets.push({
        id: 'audio',
        tracks: audioTracks,
    });
    return audioSwitchingSets;
}
//# sourceMappingURL=audioGroupsToSwitchingSets.js.map