"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readTerminatedString = readTerminatedString;
const readUint_js_1 = require("./readUint.js");
function readTerminatedString(dataView, offset) {
    let str = '';
    let cursor = offset;
    while (cursor - dataView.byteOffset < dataView.byteLength) {
        const char = (0, readUint_js_1.readUint)(dataView, cursor, 1);
        if (char === 0) {
            break;
        }
        str += String.fromCharCode(char);
        cursor++;
    }
    return str;
}
;
//# sourceMappingURL=readTerminatedString.js.map