import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * ISO/IEC 14496-12:2012 - 8.8.3 Track Extends Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type TrackExtendsBox = FullBox & {
    trackId: number;
    defaultSampleDescriptionIndex: number;
    defaultSampleDuration: number;
    defaultSampleSize: number;
    defaultSampleFlags: number;
};
/**
 * Parse a TrackExtendsBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed TrackExtendsBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function trex(view: IsoView): TrackExtendsBox;
//# sourceMappingURL=trex.d.ts.map