import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * ISO/IEC 14496-12:2012 - 8.8.7 Track Fragment Header Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type TrackFragmentHeaderBox = FullBox & {
    trackId: number;
    baseDataOffset?: number;
    sampleDescriptionOffset?: number;
    defaultSampleDuration?: number;
    defaultSampleSize?: number;
    defaultSampleFlags?: number;
};
/**
 * Parse a TrackFragmentHeaderBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed TrackFragmentHeaderBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function tfhd(view: IsoView): TrackFragmentHeaderBox;
//# sourceMappingURL=tfhd.d.ts.map