"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.stts = stts;
/**
 * Parse a DecodingTimeToSampleBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed DecodingTimeToSampleBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
function stts(view) {
    const { version, flags } = view.readFullBox();
    const entryCount = view.readUint(4);
    const entries = view.readEntries(entryCount, () => ({
        sampleCount: view.readUint(4),
        sampleDelta: view.readUint(4),
    }));
    return {
        version,
        flags,
        entryCount,
        entries,
    };
}
;
//# sourceMappingURL=stts.js.map