import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * ISO/IEC 14496-12:2012 - 8.5.2 Sample Description Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type SampleDescriptionBox = FullBox & {
    entryCount: number;
    entries: any[];
};
/**
 * Parse a SampleDescriptionBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed SampleDescriptionBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function stsd(view: IsoView): SampleDescriptionBox;
//# sourceMappingURL=stsd.d.ts.map