import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * Subsegment range
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type Range = {
    level: number;
    rangeSize: number;
};
/**
 * Subsegment
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type Subsegment = {
    rangesCount: number;
    ranges: Range[];
};
/**
 * ISO/IEC 14496-12:2012 - 8.16.4 Subsegment Index Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type SubsegmentIndexBox = FullBox & {
    subsegmentCount: number;
    subsegments: Subsegment[];
};
/**
 * Parse a SubsegmentIndexBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed SubsegmentIndexBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function ssix(view: IsoView): SubsegmentIndexBox;
//# sourceMappingURL=ssix.d.ts.map