"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.schm = schm;
/**
 * Parse a SchemeTypeBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed SchemeTypeBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
function schm(view) {
    const { version, flags } = view.readFullBox();
    return {
        version,
        flags,
        schemeType: view.readUint(4),
        schemeVersion: view.readUint(4),
        schemeUri: flags & 0x000001 ? view.readString(-1) : undefined,
    };
}
;
//# sourceMappingURL=schm.js.map