"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pssh = pssh;
const UINT_js_1 = require("../fields/UINT.js");
/**
 * Parse a ProtectionSystemSpecificHeaderBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed ProtectionSystemSpecificHeaderBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
function pssh(view) {
    const { readUint, readArray } = view;
    const { version, flags } = view.readFullBox();
    const systemID = readArray(UINT_js_1.UINT, 1, 16);
    const dataSize = readUint(4);
    const data = readArray(UINT_js_1.UINT, 1, dataSize);
    return {
        version,
        flags,
        systemID,
        dataSize,
        data,
    };
}
;
//# sourceMappingURL=pssh.js.map