"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mvhd = mvhd;
const UINT_js_1 = require("../fields/UINT.js");
/**
 * Parse a Box from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
function mvhd(view) {
    const { readUint, readTemplate, readArray } = view;
    const { version, flags } = view.readFullBox();
    const size = (version == 1) ? 8 : 4;
    return {
        version,
        flags,
        creationTime: readUint(size),
        modificationTime: readUint(size),
        timescale: readUint(4),
        duration: readUint(size),
        rate: readTemplate(4),
        volume: readTemplate(2),
        reserved1: readUint(2),
        reserved2: readArray(UINT_js_1.UINT, 4, 2),
        matrix: readArray(UINT_js_1.UINT, 4, 9),
        preDefined: readArray(UINT_js_1.UINT, 4, 6),
        nextTrackId: readUint(4),
    };
}
;
//# sourceMappingURL=mvhd.js.map