"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mfhd = mfhd;
/**
 * Parse a MovieFragmentHeaderBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed MovieFragmentHeaderBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
function mfhd(view) {
    return {
        ...view.readFullBox(),
        sequenceNumber: view.readUint(4),
    };
}
;
//# sourceMappingURL=mfhd.js.map