"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.imda = imda;
/**
 * Parse a IdentifiedMediaDataBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed IdentifiedMediaDataBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
function imda(view) {
    return {
        imdaIdentifier: view.readUint(4),
        data: view.readData(-1),
    };
}
;
//# sourceMappingURL=imda.js.map