"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ftyp = ftyp;
const STRING_js_1 = require("../fields/STRING.js");
/**
 * Parse a FileTypeBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed FileTypeBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
function ftyp(view) {
    const size = 4;
    const majorBrand = view.readString(4);
    const minorVersion = view.readUint(4);
    const length = view.bytesRemaining / size;
    const compatibleBrands = view.readArray(STRING_js_1.STRING, size, length);
    return {
        majorBrand,
        minorVersion,
        compatibleBrands,
    };
}
//# sourceMappingURL=ftyp.js.map