import type { IsoView } from '../IsoView.js';
/**
 * ISO/IEC 14496-12:2012 - 8.12.2 Original Format Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type OriginalFormatBox = {
    dataFormat: number;
};
/**
 * Parse an OriginalFormatBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed OriginalFormatBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function frma(view: IsoView): OriginalFormatBox;
//# sourceMappingURL=frma.d.ts.map