import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * An edit list entry.
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type EditListEntry = {
    segmentDuration: number;
    mediaTime: number;
    mediaRateInteger: number;
    mediaRateFraction: number;
};
/**
 * ISO/IEC 14496-12:2012 - 8.6.6 Edit List Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type EditListBox = FullBox & {
    entryCount: number;
    entries: EditListEntry[];
};
/**
 * Parse a Box from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function elst(view: IsoView): EditListBox;
//# sourceMappingURL=elst.d.ts.map