"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.filterBoxesByType = filterBoxesByType;
const filterBoxes_js_1 = require("./filterBoxes.js");
/**
 * Filter boxes by type from an IsoView
 *
 * @param type - The type of boxes to filter
 * @param raw - The raw ISO data
 * @param config - The configuration for the IsoView
 *
 * @returns The filtered boxes
 *
 * @group ISOBMFF
 *
 * @beta
 */
function filterBoxesByType(type, raw, config = {}) {
    return (0, filterBoxes_js_1.filterBoxes)(raw, config, box => box.type === type);
}
//# sourceMappingURL=filterBoxesByType.js.map