import type { Box } from './Box.js';
import type { IsoData } from './IsoData.js';
import type { IsoViewConfig } from './IsoViewConfig.js';
/**
 * Filter boxes by type from an IsoView
 *
 * @param type - The type of boxes to filter
 * @param raw - The raw ISO data
 * @param config - The configuration for the IsoView
 *
 * @returns The filtered boxes
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function filterBoxesByType(type: string, raw: IsoData, config?: IsoViewConfig): Box[];
//# sourceMappingURL=filterBoxesByType.d.ts.map