import type { Box } from './Box.js';
import type { BoxFilter } from './BoxFilter.js';
import type { IsoData } from './IsoData.js';
import type { IsoViewConfig } from './IsoViewConfig.js';
/**
 * Filters boxes based on the given filter function.
 *
 * @param raw - The raw boxes to filter.
 * @param config - The box parser configuration.
 * @param fn - The filter function.
 * @returns The filtered boxes.
 *
 * @group ISOBMFF
 * @beta
 */
export declare function filterBoxes(raw: IsoData, config: IsoViewConfig, fn: BoxFilter): Box[];
//# sourceMappingURL=filterBoxes.d.ts.map