"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapHlsToHam = mapHlsToHam;
const audioGroupsToSwitchingSets_js_1 = require("./audioGroupsToSwitchingSets.js");
const subtitleGroupsToSwitchingSets_js_1 = require("./subtitleGroupsToSwitchingSets.js");
const videoPlaylistsToSwitchingSets_js_1 = require("./videoPlaylistsToSwitchingSets.js");
const parseHlsManifest_js_1 = require("../../../utils/hls/parseHlsManifest.js");
const addMetadataToHls_js_1 = require("../../../utils/manifest/addMetadataToHls.js");
function mapHlsToHam(manifest) {
    var _a, _b;
    const mainManifestParsed = (0, parseHlsManifest_js_1.parseHlsManifest)(manifest.manifest);
    const manifestHls = (0, addMetadataToHls_js_1.addMetadataToHls)(manifest, mainManifestParsed);
    const selectionSets = [];
    const manifestPlaylists = manifestHls.ancillaryManifests
        ? [...manifestHls.ancillaryManifests]
        : [];
    const audioSwitchingSets = (0, audioGroupsToSwitchingSets_js_1.audioGroupsToSwitchingSets)((_a = mainManifestParsed.mediaGroups) === null || _a === void 0 ? void 0 : _a.AUDIO, manifestPlaylists);
    const subtitleSwitchingSets = (0, subtitleGroupsToSwitchingSets_js_1.subtitleGroupsToSwitchingSets)((_b = mainManifestParsed.mediaGroups) === null || _b === void 0 ? void 0 : _b.SUBTITLES, manifestPlaylists);
    const videoSwitchingSets = (0, videoPlaylistsToSwitchingSets_js_1.videoPlaylistsToSwitchingSets)(mainManifestParsed.playlists, manifestPlaylists);
    let selectionSetId = 0;
    if (audioSwitchingSets.length > 0) {
        selectionSets.push({
            id: (selectionSetId++).toString(),
            switchingSets: audioSwitchingSets,
        });
    }
    if (subtitleSwitchingSets.length > 0) {
        selectionSets.push({
            id: (selectionSetId++).toString(),
            switchingSets: subtitleSwitchingSets,
        });
    }
    if (videoSwitchingSets.length > 0) {
        selectionSets.push({
            id: (selectionSetId++).toString(),
            switchingSets: videoSwitchingSets,
        });
    }
    let presentationId = 0;
    return [
        { id: (presentationId++).toString(), selectionSets: selectionSets },
    ];
}
//# sourceMappingURL=mapHlsToHam.js.map