import type { Components } from '@ionic/core';
import type { JSX as LocalJSX } from '@ionic/core/components';
import React from 'react';
import { NavContext } from '../../contexts/NavContext';
import type { IonTabsContextState } from './IonTabsContext';
export interface IonTabsProps extends React.HTMLAttributes<Components.IonTabs> {
    onIonTabsWillChange?: (event: CustomEvent<{
        tab: string;
    }>) => void;
    onIonTabsDidChange?: (event: CustomEvent<{
        tab: string;
    }>) => void;
}
declare module 'react' {
    interface HTMLElements {
        'ion-tabs': IonTabsProps;
    }
}
type ChildFunction = (ionTabContext: IonTabsContextState) => React.ReactNode;
interface Props extends LocalJSX.IonTabs {
    className?: string;
    children: ChildFunction | React.ReactNode;
    onIonTabsWillChange?: (event: CustomEvent<{
        tab: string;
    }>) => void;
    onIonTabsDidChange?: (event: CustomEvent<{
        tab: string;
    }>) => void;
}
export declare class IonTabs extends React.Component<Props> {
    shouldComponentUpdate(): boolean;
    context: React.ContextType<typeof NavContext>;
    /**
     * `routerOutletRef` allows users to add a `ref` to `IonRouterOutlet`.
     * Without this, `ref.current` will be `undefined` in the user's app,
     * breaking their ability to access the `IonRouterOutlet` instance.
     * Do not remove this ref.
     */
    routerOutletRef: React.Ref<Components.IonRouterOutlet>;
    selectTabHandler?: (tag: string) => boolean;
    tabBarRef: React.RefObject<any>;
    ionTabContextState: IonTabsContextState;
    constructor(props: Props);
    componentDidMount(): void;
    renderTabsInner(children: React.ReactNode, outlet: React.ReactElement<{}> | undefined): import("react/jsx-runtime").JSX.Element;
    render(): import("react/jsx-runtime").JSX.Element;
    static get contextType(): React.Context<import("../../contexts/NavContext").NavContextState>;
}
export {};
