'use strict';

var core = require('@capacitor/core');

const TextZoom = core.registerPlugin('TextZoom', {
    ios: () => Promise.resolve().then(function () { return ios; }).then(m => new m.TextZoomIOS()),
});

class TextZoomIOS {
    async get() {
        const percentage = this.getRaw();
        const value = this.textSizePercentageToNumber(percentage);
        return { value };
    }
    async getPreferred() {
        throw 'Native implementation will be used';
    }
    async set(options) {
        const num = this.textSizeNumberToPercentage(options.value);
        this.setRaw(num);
    }
    getRaw() {
        if (typeof document !== 'undefined') {
            return document.body.style.webkitTextSizeAdjust || '100%';
        }
        return '100%';
    }
    setRaw(value) {
        if (typeof document !== 'undefined') {
            document.body.style.webkitTextSizeAdjust = value;
        }
    }
    textSizePercentageToNumber(percentage) {
        const m = TextZoomIOS.TEXT_SIZE_REGEX.exec(percentage);
        if (!m) {
            return 1;
        }
        const parsed = Number.parseInt(m[1], 10);
        if (Number.isNaN(parsed)) {
            return 1;
        }
        return parsed / 100;
    }
    textSizeNumberToPercentage(num) {
        return `${Math.round(num * 100)}%`;
    }
}
TextZoomIOS.TEXT_SIZE_REGEX = /(\d+)%/;

var ios = /*#__PURE__*/Object.freeze({
    __proto__: null,
    TextZoomIOS: TextZoomIOS
});

exports.TextZoom = TextZoom;
//# sourceMappingURL=plugin.cjs.js.map
