// SPDX-FileCopyrightText: Adam Evyčędo
//
// SPDX-License-Identifier: GPL-3.0-or-later

package xyz.apiote.bimba.czwek.api

import org.junit.Assert.assertTrue
import org.junit.Test

class TransitousJourneyTest {
	@Test
	fun decodeSeoul7() {
		val positions = decode("wbwokUyyk|tjA", 7)
		assertTrue(
			"expected 37, got ${positions[0].positionLatitude.toInt()}",
			positions[0].positionLatitude.toInt() == 37
		)
		assertTrue(
			"expected 126, got ${positions[0].positionLongitude.toInt()}",
			positions[0].positionLongitude.toInt() == 126
		)
	}

	@Test
	fun decodeBrussels6() {
		val positions = decode("qqj_`Bsr_iG", 6)
		assertTrue(
			"expected 50, got ${positions[0].positionLatitude.toInt()}",
			positions[0].positionLatitude.toInt() == 50
		)
		assertTrue(
			"expected 4, got ${positions[0].positionLongitude.toInt()}",
			positions[0].positionLongitude.toInt() == 4
		)
	}
}
