// SPDX-FileCopyrightText: Adam Evyčędo
//
// SPDX-License-Identifier: GPL-3.0-or-later

package xyz.apiote.bimba.czwek.settings

import android.os.Bundle
import android.view.View
import android.view.ViewGroup
import androidx.activity.enableEdgeToEdge
import androidx.appcompat.app.AppCompatActivity
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat
import androidx.core.view.updateLayoutParams
import androidx.core.view.updatePadding
import androidx.preference.PreferenceFragmentCompat
import xyz.apiote.bimba.czwek.R


class SettingsActivity : AppCompatActivity() {

	override fun onCreate(savedInstanceState: Bundle?) {
		enableEdgeToEdge()
		super.onCreate(savedInstanceState)
		setContentView(R.layout.settings_activity)
		if (savedInstanceState == null) {
			supportFragmentManager.beginTransaction().replace(R.id.settings, SettingsFragment()).commit()
		}
		supportActionBar?.setDisplayHomeAsUpEnabled(true)

		val root = findViewById<View>(R.id.settings)

		ViewCompat.setOnApplyWindowInsetsListener(root) { v, windowInsets ->
			val insets = windowInsets.getInsets(WindowInsetsCompat.Type.systemBars())
			v.updatePadding(left = windowInsets.displayCutout?.safeInsetLeft?.takeIf { it > 0 }
				?: insets.left)
			v.updatePadding(right = windowInsets.displayCutout?.safeInsetRight?.takeIf { it > 0 }
				?: insets.right)
			v.updateLayoutParams<ViewGroup.MarginLayoutParams> {
				topMargin = insets.top
			}
			windowInsets
		}
	}

	class SettingsFragment : PreferenceFragmentCompat() {
		override fun onCreatePreferences(savedInstanceState: Bundle?, rootKey: String?) {
			setPreferencesFromResource(R.xml.root_preferences, rootKey)
		}
	}
}