// SPDX-FileCopyrightText: Adam Evyčędo
//
// SPDX-License-Identifier: GPL-3.0-or-later

package xyz.apiote.bimba.czwek.repo

import xyz.apiote.bimba.czwek.data.traffic.Place
import xyz.apiote.bimba.czwek.units.Mps
import java.time.ZoneId

data class StopTime(val place: Place, val event: Event) {
	constructor(p: xyz.apiote.bimba.czwek.api.transitous.model.Place) : this(
		Stop(p),
		Event(
			"",
			p.arrival?.atZoneSameInstant(p.tz?.let { ZoneId.of(it) } ?: ZoneId.systemDefault()),
			p.scheduledArrival?.atZoneSameInstant(p.tz?.let { ZoneId.of(it) }
				?: ZoneId.systemDefault()),
			p.departure?.atZoneSameInstant(p.tz?.let { ZoneId.of(it) }
				?: ZoneId.systemDefault()),
			p.scheduledDeparture?.atZoneSameInstant(p.tz?.let { ZoneId.of(it) }
				?: ZoneId.systemDefault()),
			0u,
			false,
			Vehicle(
				"",
				Position(0.0, 0.0),
				0u,
				Mps(0),
				LineStub("", LineType.MISC, Colour(0u, 0u, 0u)),
				"",
				CongestionLevel.UNKNOWN,
				OccupancyStatus.UNKNOWN
			),
			Event.boardingFromTransitous(p.pickupType, p.dropoffType),
			emptyList<Alert>(),
			exact = true,
			terminusArrival = false, // TODO
			p.track,
			p.scheduledTrack
		)
	)
}